﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Collections;
using MassduinoUsbHid;
namespace MassduinoHidDataDemo
{
    public partial class Form1 : Form
    {
        MassduinoUsbHid.Device device = null;
        public Form1()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Close the device currently opened
        /// </summary>
        public void CloseDevice()
        {
            if(device != null)
            {
                //Remove the usb report string handler
                device.reportString -= ReportString;
                try
                {
                    //Invoke the close function
                    device.Close();
                }
                catch (Exception)
                {
                }
            }
        }

        /// <summary>
        /// Open the device corresponding the serialNumber
        /// </summary>
        /// <param name="serialNumber"></param>
        public void OpenDevice(String serialNumber)
        {
            CloseDevice();
            //Get the new open device
            device = new MassduinoUsbHid.Device(serialNumber);
            //Add the usb report string handler
            device.reportString += ReportString;
        }

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            //Before the form1 closed, we must close the opened device
            CloseDevice();
        }

        /// <summary>
        /// The report string handler function
        /// It can add the recv string to textBox1
        /// Because this function is called by other thread so here it need to used the invoke mechanism to avoid the exceptions happen
        /// </summary>
        /// <param name="SerialNumber"></param>
        /// <param name="str"></param>
        delegate void dlReportString(string SerialNumber, ref string str);
        void ReportString(string SerialNumber, ref string str)
        {
            if (textBox1.InvokeRequired)
            {
                dlReportString pInvoke = ReportString;
                this.Invoke(pInvoke, new Object[] { SerialNumber, str });
            }
            else
            {
                try
                {
                    if (textBox1.Text.Length > 4096)
                    {
                        textBox1.Text = "";
                    }
                    textBox1.Text += str;
                }
                catch (Exception e)
                {
                    String msg = e.Message;
                }
            }
        }

        private void bt_Clear_Click(object sender, EventArgs e)
        {
            textBox1.Text = "";
        }

        private void bt_Send_Click(object sender, EventArgs e)
        {
            if(txt_Input.Text.Length == 0)
            {
                MessageBox.Show("Input text connot be empty!");
                return;
            }
            if (combo_DeviceList.SelectedIndex < 0)
            {
                MessageBox.Show("Please select a device!");
                return;
            }

            //call the writeString function
            String inputStr = txt_Input.Text;
            device.writeString(ref inputStr);
        }

        private void bt_Search_Click(object sender, EventArgs e)
        {
            combo_DeviceList.Items.Clear();

            //New a list object to receive the sn list
            ArrayList deviceSnList = new ArrayList();
            //Call the searchDevices to get all the devices currently exist on system
            MassduinoUsbHid.Device.searchDevices(ref deviceSnList);

            //Add all the searched device's sn to Device List one by one
            int index = 0;
            foreach (var pItem in deviceSnList)
	        {
		        combo_DeviceList.Items.Add(pItem);
                index ++;
	        }
        }

        private void combo_DeviceList_SelectedIndexChanged(object sender, EventArgs e)
        {
            if(combo_DeviceList.SelectedIndex < 0)
            {
                return;
            }

            //Here to open the device which selected, ready to receive any string from the usb
            OpenDevice(combo_DeviceList.Text);
        }
    }
}
